#!/bin/sh
# (c) 2015 Thomas BERNARD
# miniupnp@free.fr / thomas@cls.to

IPTABLES=$(which iptables)
OUR_PORT=1901
IF=vlan2
REDIR_BIN=/jffs/bin/redir_ports
SCRIPT=/jffs/bin/redir_ports.sh
CRONTAB=/tmp/crontab
#LOGFILE="/var/log/redir_ports_$(date +%H%M)"
LOGFILE="/var/log/redir_ports"
LOGLINELIMIT=200

# rotate logs
loglines=$(cat $LOGFILE | wc -l)
if [ $loglines -gt $LOGLINELIMIT ] ; then
	if [ -f "$LOGFILE.1" ] ; then
		mv "$LOGFILE.1" "$LOGFILE.2"
	fi
	mv "$LOGFILE" "$LOGFILE.1"
fi

if [ -f $LOGFILE ] ; then
	echo "----" >> $LOGFILE
fi

#PORTS="4242 12345u 54321"
# to set, use nvram command :
#   $ nvram set redir_ports="1234 12345 5467u ..."
#   $ nvram commit
if [ -z "$*" ] ; then
	PORTS=$(nvram get redir_ports)
else
	PORTS=$*
fi
echo "$(date +%F_%H:%M) setting redirections to ports $PORTS" | tee -a $LOGFILE

# -C is not supported ?
#if $IPTABLES -C INPUT -p udp --dport $OUR_PORT -j ACCEPT ; then
#fi
$IPTABLES -I INPUT -p udp --dport $OUR_PORT -j ACCEPT
$REDIR_BIN -i $IF -z $OUR_PORT $PORTS | tee -a $LOGFILE
$IPTABLES -D INPUT -p udp --dport $OUR_PORT -j ACCEPT

if ! grep -q $SCRIPT $CRONTAB ; then
	echo "installing crontab."
	echo "0,10,20,30,40,50 * * * *	root $SCRIPT" >> $CRONTAB
fi

